<script>
// Helper function untuk generate labels 12 bulan terakhir
function generateMonthLabels() {
    const labels = [];
    const now = new Date();
    for (let i = 11; i >= 0; i--) {
        const date = new Date(now.getFullYear(), now.getMonth() - i, 1);
        labels.push(date.toLocaleDateString('id-ID', { month: 'short', year: 'numeric' }));
    }
    return labels;
}

// Global chart instances
window.teknisiDashboardCharts = {
    productions: null,
    usage: null,
    status: null,
    initialized: false
};

// Function to initialize charts
function initializeTeknisiDashboardCharts() {
    console.log('[Teknisi Charts] Initialization attempt...');
    
    // Check if Chart.js is available
    if (typeof Chart === 'undefined') {
        console.warn('[Teknisi Charts] Chart.js not loaded yet, retrying...');
        setTimeout(initializeTeknisiDashboardCharts, 200);
        return;
    }
    
    console.log('[Teknisi Charts] Chart.js is loaded');
    
    // Check if charts already initialized
    if (window.teknisiDashboardCharts.initialized) {
        console.log('[Teknisi Charts] Charts already initialized');
        return;
    }
    
    // Check if elements exist
    const productionsCtx = document.getElementById('productionsChart');
    const usageCtx = document.getElementById('usageChart');
    
    console.log('[Teknisi Charts] Checking elements:', {
        productionsChart: !!productionsCtx,
        usageChart: !!usageCtx
    });
    
    if (!productionsCtx || !usageCtx) {
        console.warn('[Teknisi Charts] Chart elements not found yet, retrying...');
        setTimeout(initializeTeknisiDashboardCharts, 200);
        return;
    }
    
    // Proceed with initialization
    console.log('[Teknisi Charts] Starting chart initialization...');
    initTeknisiCharts();
}

// Theme-aware colors
function getThemeColors() {
    const isDark = document.documentElement.classList.contains('dark') || document.body.classList.contains('dark');
    return {
        text: isDark ? 'rgba(255, 255, 255, 0.7)' : 'rgba(0, 0, 0, 0.6)',
        grid: isDark ? 'rgba(255, 255, 255, 0.1)' : 'rgba(0, 0, 0, 0.1)',
    };
}

function initTeknisiCharts() {
    console.log('[Teknisi Charts] initTeknisiCharts called');
    
    // Check if Chart.js is available
    if (typeof Chart === 'undefined') {
        console.error('[Teknisi Charts] Chart.js is not loaded!');
        return;
    }

    console.log('[Teknisi Charts] Chart.js available, proceeding...');
    
    // Check if chartData is available
    <?php if(!isset($chartData)): ?>
        console.error('[Teknisi Charts] Chart data is not available!');
        return;
    <?php else: ?>
        console.log('[Teknisi Charts] Chart data is available');
    <?php endif; ?>

    let themeColors = getThemeColors();
    console.log('[Teknisi Charts] Theme colors:', themeColors);
    
    // Chart 1: Produksi Selesai per Bulan
    try {
        const productionsCtx = document.getElementById('productionsChart');
        if (!productionsCtx) {
            console.error('productionsChart element not found');
            return;
        }

        const ctx2d = productionsCtx.getContext('2d');
        if (!ctx2d) {
            console.error('Could not get 2d context for productionsChart');
            return;
        }

        // Set canvas size if needed
        const container = productionsCtx.parentElement;
        if (container && (productionsCtx.width === 0 || productionsCtx.height === 0)) {
            productionsCtx.width = container.offsetWidth || 400;
            productionsCtx.height = container.offsetHeight || 300;
        }

        const chartHeight = productionsCtx.height || 300;
        
        const gradient = ctx2d.createLinearGradient(0, 0, 0, chartHeight);
        gradient.addColorStop(0, 'rgba(59, 130, 246, 0.8)');
        gradient.addColorStop(1, 'rgba(59, 130, 246, 0.2)');
        
        window.teknisiDashboardCharts.productions = new Chart(ctx2d, {
            type: 'line',
            data: {
                labels: generateMonthLabels(),
                datasets: [{
                    label: 'Produksi Selesai',
                    data: <?php echo json_encode($chartData['productions']->toArray()); ?>,
                    borderColor: 'rgb(59, 130, 246)',
                    backgroundColor: gradient,
                    tension: 0.5,
                    fill: true,
                    pointBackgroundColor: 'rgb(59, 130, 246)',
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 3,
                    pointRadius: 4,
                    pointHoverRadius: 8,
                    pointHoverBorderWidth: 3,
                    borderWidth: 3,
                    cubicInterpolationMode: 'monotone'
                }]
            },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top',
                            labels: {
                                color: themeColors.text,
                                font: { size: 12, weight: '500' },
                                padding: 15
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            padding: 12,
                            titleFont: { size: 14, weight: 'bold' },
                            bodyFont: { size: 13 },
                            cornerRadius: 8,
                            displayColors: true
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                color: themeColors.text,
                                font: { size: 11 },
                                stepSize: 1,
                                precision: 0
                            },
                            grid: {
                                color: themeColors.grid,
                                drawBorder: false
                            }
                        },
                        x: {
                            ticks: {
                                color: themeColors.text,
                                font: { size: 11 },
                                maxRotation: 45,
                                minRotation: 45
                            },
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
        }
    } catch (error) {
        console.error('Error initializing productions chart:', error);
    }

    // Chart 2: Penggunaan Bahan & Sparepart
    try {
        const usageCtx = document.getElementById('usageChart');
        if (!usageCtx) {
            console.error('usageChart element not found');
            return;
        }

        const ctx2d = usageCtx.getContext('2d');
        if (!ctx2d) {
            console.error('Could not get 2d context for usageChart');
            return;
        }

        // Set canvas size if needed
        const container = usageCtx.parentElement;
        if (container && (usageCtx.width === 0 || usageCtx.height === 0)) {
            usageCtx.width = container.offsetWidth || 400;
            usageCtx.height = container.offsetHeight || 300;
        }

        const chartHeight = usageCtx.height || 300;
        
        const materialsGradient = ctx2d.createLinearGradient(0, 0, 0, chartHeight);
        materialsGradient.addColorStop(0, 'rgba(34, 197, 94, 0.8)');
        materialsGradient.addColorStop(1, 'rgba(34, 197, 94, 0.2)');
        
        const sparepartsGradient = ctx2d.createLinearGradient(0, 0, 0, chartHeight);
        sparepartsGradient.addColorStop(0, 'rgba(168, 85, 247, 0.8)');
        sparepartsGradient.addColorStop(1, 'rgba(168, 85, 247, 0.2)');
        
        window.teknisiDashboardCharts.usage = new Chart(ctx2d, {
            type: 'bar',
            data: {
                labels: generateMonthLabels(),
                datasets: [{
                    label: 'Bahan (Rp)',
                    data: <?php echo json_encode($chartData['materials_usage']->toArray()); ?>,
                        backgroundColor: materialsGradient,
                        borderColor: 'rgb(34, 197, 94)',
                        borderWidth: 2,
                        borderRadius: { topLeft: 8, topRight: 8 },
                        maxBarThickness: 40
                    }, {
                        label: 'Sparepart (Rp)',
                        data: <?php echo json_encode($chartData['spareparts_usage']->toArray()); ?>,
                        backgroundColor: sparepartsGradient,
                        borderColor: 'rgb(168, 85, 247)',
                        borderWidth: 2,
                        borderRadius: { topLeft: 8, topRight: 8 },
                        maxBarThickness: 40
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top',
                            labels: {
                                color: themeColors.text,
                                font: { size: 12, weight: '500' },
                                padding: 15
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            padding: 12,
                            titleFont: { size: 14, weight: 'bold' },
                            bodyFont: { size: 13 },
                            cornerRadius: 8,
                            callbacks: {
                                label: function(context) {
                                    const value = context.parsed.y;
                                    return context.dataset.label + ': Rp ' + new Intl.NumberFormat('id-ID').format(value);
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                color: themeColors.text,
                                font: { size: 11 },
                                callback: function(value) {
                                    if (value >= 1000000) {
                                        return 'Rp ' + (value / 1000000).toFixed(1) + 'M';
                                    } else if (value >= 1000) {
                                        return 'Rp ' + (value / 1000).toFixed(0) + 'K';
                                    }
                                    return 'Rp ' + value;
                                }
                            },
                            grid: {
                                color: themeColors.grid,
                                drawBorder: false
                            }
                        },
                        x: {
                            ticks: {
                                color: themeColors.text,
                                font: { size: 11 },
                                maxRotation: 45,
                                minRotation: 45
                            },
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
        }
    } catch (error) {
        console.error('Error initializing usage chart:', error);
    }

    // Chart 3: Status Produksi (Pie Chart)
    <?php if(($chartData['status_distribution'] ?? collect())->isNotEmpty()): ?>
    try {
        const statusCtx = document.getElementById('statusChart');
        if (!statusCtx) {
            console.warn('statusChart element not found, skipping...');
        } else {
            const statusData = <?php echo json_encode($chartData['status_distribution']->toArray() ?? []); ?>;
            const labels = Object.keys(statusData);
            const data = Object.values(statusData);
            
            const colors = {
                'menunggu': 'rgba(156, 163, 175, 0.8)',
                'dalam_proses': 'rgba(99, 102, 241, 0.8)',
                'planning': 'rgba(59, 130, 246, 0.8)',
                'pending_approval': 'rgba(234, 179, 8, 0.8)',
            };
            
            const borderColors = {
                'menunggu': 'rgb(156, 163, 175)',
                'dalam_proses': 'rgb(99, 102, 241)',
                'planning': 'rgb(59, 130, 246)',
                'pending_approval': 'rgb(234, 179, 8)',
            };
            
            const backgroundColor = labels.map(label => colors[label] || 'rgba(100, 100, 100, 0.8)');
            const borderColor = labels.map(label => borderColors[label] || 'rgb(100, 100, 100)');
            
            // Format labels
            const formattedLabels = labels.map(label => {
                return label.replace('_', ' ').split(' ').map(word => 
                    word.charAt(0).toUpperCase() + word.slice(1)
                ).join(' ');
            });
            
            window.teknisiDashboardCharts.status = new Chart(statusCtx, {
                type: 'doughnut',
                data: {
                    labels: formattedLabels,
                    datasets: [{
                        data: data,
                        backgroundColor: backgroundColor,
                        borderColor: borderColor,
                        borderWidth: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'right',
                            labels: {
                                color: themeColors.text,
                                font: { size: 12, weight: '500' },
                                padding: 15,
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        return data.labels.map((label, i) => {
                                            const value = data.datasets[0].data[i];
                                            return {
                                                text: label + ': ' + value,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor[i],
                                                lineWidth: data.datasets[0].borderWidth,
                                                hidden: false,
                                                index: i
                                            };
                                        });
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            padding: 12,
                            titleFont: { size: 14, weight: 'bold' },
                            bodyFont: { size: 13 },
                            cornerRadius: 8,
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.parsed || 0;
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = ((value / total) * 100).toFixed(1);
                                    return label + ': ' + value + ' (' + percentage + '%)';
                                }
                            }
                        }
                    }
                }
            });
        }
    } catch (error) {
        console.error('Error initializing status chart:', error);
    }
    <?php endif; ?>

    // Mark as initialized
    window.teknisiDashboardCharts.initialized = true;
    console.log('Teknisi dashboard charts initialized successfully');
}

// Wait for DOM to be ready
console.log('[Teknisi Charts] Script loaded, document readyState:', document.readyState);

if (document.readyState === 'loading') {
    console.log('[Teknisi Charts] Waiting for DOMContentLoaded...');
    document.addEventListener('DOMContentLoaded', function() {
        console.log('[Teknisi Charts] DOMContentLoaded fired');
        initializeTeknisiDashboardCharts();
    });
} else {
    // DOM already loaded, initialize immediately
    console.log('[Teknisi Charts] DOM already loaded, initializing immediately...');
    initializeTeknisiDashboardCharts();
}

// Also try after window load (in case scripts load late)
window.addEventListener('load', function() {
    console.log('[Teknisi Charts] Window load event fired');
    setTimeout(function() {
        if (!window.teknisiDashboardCharts.initialized) {
            console.log('[Teknisi Charts] Retrying chart initialization after window load...');
            initializeTeknisiDashboardCharts();
        } else {
            console.log('[Teknisi Charts] Charts already initialized, skipping retry');
        }
    }, 100);
});

// Re-initialize on dark mode toggle
if (typeof toggleDarkMode === 'function') {
    const originalToggleDarkMode = toggleDarkMode;
    window.toggleDarkMode = function() {
        originalToggleDarkMode();
        setTimeout(function() {
            if (window.teknisiDashboardCharts.productions) {
                window.teknisiDashboardCharts.productions.destroy();
            }
            if (window.teknisiDashboardCharts.usage) {
                window.teknisiDashboardCharts.usage.destroy();
            }
            if (window.teknisiDashboardCharts.status) {
                window.teknisiDashboardCharts.status.destroy();
            }
            window.teknisiDashboardCharts.initialized = false;
            initializeTeknisiDashboardCharts();
        }, 100);
    };
}
</script>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/teknisi/partials/dashboard-charts-script.blade.php ENDPATH**/ ?>