<!-- Stats Cards Row 1 - Key Metrics -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6 w-full">
    <!-- Card 1: Sedang Planning -->
    <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-blue-100 text-sm font-medium">Sedang Planning</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-edit text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['my_planning_productions'] ?? 0); ?></h3>
            <p class="text-blue-100 text-sm">Perlu dibuatkan planning produksi</p>
        </div>
    </div>

    <!-- Card 2: Menunggu Approval -->
    <div class="bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-yellow-100 text-sm font-medium">Menunggu Approval</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-clock text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['my_pending_approvals'] ?? 0); ?></h3>
            <p class="text-yellow-100 text-sm">Planning menunggu persetujuan supervisor</p>
        </div>
    </div>

    <!-- Card 3: Produksi Aktif -->
    <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-green-100 text-sm font-medium">Produksi Aktif</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-cogs text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['my_active_productions'] ?? 0); ?></h3>
            <p class="text-green-100 text-sm">Sedang dalam proses pengerjaan</p>
        </div>
    </div>

    <!-- Card 4: Stock Alert -->
    <div class="bg-gradient-to-br from-red-500 to-red-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-red-100 text-sm font-medium">Stock Alert</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-exclamation-triangle text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['total_low_stock'] ?? 0); ?></h3>
            <div class="flex items-center gap-3 text-sm">
                <span class="text-red-100">Materials: <?php echo e($stats['low_stock_materials'] ?? 0); ?></span>
                <span class="text-red-200">•</span>
                <span class="text-red-100">Spareparts: <?php echo e($stats['low_stock_spareparts'] ?? 0); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Additional Stats Cards Row 2 -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6">
    <!-- Card 5: Selesai Bulan Ini -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Selesai Bulan Ini</p>
            <div class="bg-gray-100 dark:bg-gray-700 rounded-lg p-2.5">
                <i class="fas fa-check-circle text-gray-600 dark:text-gray-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['completed_productions'] ?? 0); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Produksi yang sudah selesai
        </p>
    </div>

    <!-- Card 6: Total Biaya Bahan -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Total Biaya Bahan</p>
            <div class="bg-green-100 dark:bg-green-900/30 rounded-lg p-2.5">
                <i class="fas fa-box text-green-600 dark:text-green-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Rp <?php echo e(number_format($stats['monthly_material_usage'] ?? 0, 0, ',', '.')); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Penggunaan bahan baku bulan ini
        </p>
    </div>

    <!-- Card 7: Total Biaya Sparepart -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Total Biaya Sparepart</p>
            <div class="bg-purple-100 dark:bg-purple-900/30 rounded-lg p-2.5">
                <i class="fas fa-tools text-purple-600 dark:text-purple-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Rp <?php echo e(number_format($stats['monthly_sparepart_usage'] ?? 0, 0, ',', '.')); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Penggunaan sparepart bulan ini
        </p>
    </div>

    <!-- Card 8: Penawaran Perlu Estimasi -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Penawaran Perlu Estimasi</p>
            <div class="bg-orange-100 dark:bg-orange-900/30 rounded-lg p-2.5">
                <i class="fas fa-calculator text-orange-600 dark:text-orange-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['pending_quotations'] ?? 0); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Penawaran menunggu estimasi
        </p>
    </div>
</div>

<!-- Alert Card - Planning Menunggu -->
<?php if(($stats['my_pending_approvals'] ?? 0) > 0): ?>
<div class="mb-6">
    <div class="bg-gradient-to-r from-amber-500 to-orange-500 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-40 h-40 bg-white/10 rounded-full -mr-20 -mt-20"></div>
        <div class="absolute bottom-0 left-0 w-32 h-32 bg-white/5 rounded-full -ml-16 -mb-16"></div>
        <div class="relative z-10 flex items-center justify-between">
            <div class="flex-1">
                <div class="flex items-center mb-3">
                    <div class="bg-white/20 rounded-lg p-2.5 mr-3">
                        <i class="fas fa-exclamation-triangle text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold mb-1">Planning Menunggu Approval</h3>
                        <p class="text-amber-100 text-sm">Planning Anda menunggu persetujuan supervisor</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div>
                        <p class="text-3xl font-bold mb-1"><?php echo e($stats['my_pending_approvals'] ?? 0); ?></p>
                        <p class="text-amber-100 text-xs">Planning menunggu</p>
                    </div>
                    <a href="<?php echo e(route('teknisi.productions.index', ['planning_status' => 'pending_approval'])); ?>" 
                       class="inline-flex items-center px-4 py-2 bg-white/20 hover:bg-white/30 rounded-lg font-medium text-sm transition-colors backdrop-blur-sm">
                        <span>Lihat Detail</span>
                        <i class="fas fa-arrow-right ml-2 text-xs"></i>
                    </a>
                </div>
            </div>
            <div class="hidden lg:block ml-6">
                <div class="bg-white/20 rounded-full p-6 backdrop-blur-sm">
                    <i class="fas fa-hourglass-half text-white text-4xl"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/teknisi/partials/dashboard-stats-cards.blade.php ENDPATH**/ ?>