

<?php $__env->startSection('title', 'Detail Produksi - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<?php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
    $materialTotal = $production->total_material_cost ?? 0;
    $sparepartTotal = $production->total_sparepart_cost ?? 0;
    $directTotal = $materialTotal + $sparepartTotal;
    $laborTotal = $production->labor_cost ?? 0;
    $actualTotal = $directTotal + $laborTotal;
    $totalCost = $actualTotal;
?>

<div class="space-y-4">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Detail Produksi #<?php echo e($production->id); ?></h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Review planning produksi dari teknisi</p>
        </div>
        <a href="<?php echo e(route('supervisor.productions.index')); ?>" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium transition-colors">
            <i class="fas fa-arrow-left mr-1"></i> Kembali
        </a>
    </div>

    <!-- Info Cards Row -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Info Produksi -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                <i class="fas fa-industry text-blue-500"></i> Info Produksi
            </h3>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">Pelanggan:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->order->customer_name ?? 'N/A'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Qty:</span>
                    <span class="font-semibold text-blue-600"><?php echo e($orderQty); ?> unit</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Teknisi:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->teknisi->name ?? 'Belum ditugaskan'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Diajukan:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->submitted_at?->format('d/m/Y') ?? '-'); ?></span>
                </div>
            </div>
        </div>

        <!-- Info Order -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                <i class="fas fa-shopping-cart text-emerald-500"></i> Info Pesanan
            </h3>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">ID Pesanan:</span>
                    <span class="font-medium text-gray-900 dark:text-white">#<?php echo e($production->order->id ?? 'N/A'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Produk:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e(Str::limit($production->product->product_title ?? 'N/A', 20)); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Harga:</span>
                    <span class="font-semibold text-emerald-600">Rp <?php echo e(number_format($production->order->price ?? 0, 0, ',', '.')); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Pembayaran:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e(ucfirst($production->order->payment_method ?? 'N/A')); ?></span>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                <i class="fas fa-chart-pie text-purple-500"></i> Ringkasan Cepat
            </h3>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">Bahan:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->productionMaterials->count()); ?> item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Sparepart:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->productionSpareparts->count()); ?> item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Total:</span>
                    <span class="font-bold text-indigo-600">Rp <?php echo e(number_format($totalCost, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Timeline Progress -->
    <?php echo $__env->make('supervisor.productions.partials.timeline', ['production' => $production], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Tabel Bahan & Sparepart -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-indigo-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-boxes text-indigo-600 text-sm"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900 dark:text-white">Daftar Bahan & Sparepart</h3>
                    <p class="text-xs text-gray-500"><?php echo e($production->productionMaterials->count() + $production->productionSpareparts->count()); ?> item · <?php echo e($orderQty); ?> unit produk</p>
                </div>
            </div>
        </div>

        <?php
            $allItems = collect();
            foreach($production->productionMaterials as $pm) {
                $allItems->push([
                    'type' => 'material',
                    'name' => $pm->material->name ?? 'N/A',
                    'quantity' => $pm->quantity,
                    'unit' => $pm->unit,
                    'unit_cost' => $pm->unit_cost,
                    'total_cost' => $pm->total_cost,
                    'stock' => $pm->material->stock ?? 0,
                ]);
            }
            foreach($production->productionSpareparts as $ps) {
                $allItems->push([
                    'type' => 'sparepart',
                    'name' => $ps->sparepart->name ?? 'N/A',
                    'quantity' => $ps->quantity,
                    'unit' => $ps->unit,
                    'unit_cost' => $ps->unit_cost,
                    'total_cost' => $ps->total_cost,
                    'stock' => $ps->sparepart->stock ?? 0,
                ]);
            }
        ?>

        <?php if($allItems->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Nama Item</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Tipe</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Jumlah</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Satuan</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Harga/Unit</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Total</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Stok</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $allItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30">
                        <td class="px-4 py-3">
                            <span class="font-medium text-gray-900 dark:text-white"><?php echo e($item['name']); ?></span>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <?php if($item['type'] === 'material'): ?>
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-[11px] font-semibold rounded-full bg-emerald-100 text-emerald-700 border border-emerald-300">
                                <i class="fas fa-cube text-emerald-500"></i> Bahan
                            </span>
                            <?php else: ?>
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-[11px] font-semibold rounded-full bg-blue-100 text-blue-700 border border-blue-300">
                                <i class="fas fa-cog text-blue-500"></i> Sparepart
                            </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 text-center font-medium text-gray-900 dark:text-white"><?php echo e($item['quantity']); ?></td>
                        <td class="px-4 py-3 text-center text-gray-600 dark:text-gray-400"><?php echo e($item['unit']); ?></td>
                        <td class="px-4 py-3 text-right text-gray-600 dark:text-gray-400">Rp <?php echo e(number_format($item['unit_cost'], 0, ',', '.')); ?></td>
                        <td class="px-4 py-3 text-right font-semibold text-gray-900 dark:text-white">Rp <?php echo e(number_format($item['total_cost'], 0, ',', '.')); ?></td>
                        <td class="px-4 py-3 text-center">
                            <?php if($item['stock'] >= $item['quantity'] * $orderQty): ?>
                            <span class="px-2 py-0.5 text-xs font-medium rounded-full bg-green-100 text-green-700"><?php echo e($item['stock']); ?></span>
                            <?php else: ?>
                            <span class="px-2 py-0.5 text-xs font-medium rounded-full bg-red-100 text-red-700"><?php echo e($item['stock']); ?> <i class="fas fa-exclamation-triangle ml-1"></i></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <td colspan="5" class="px-4 py-3">
                            <div class="flex items-center gap-4 text-sm">
                                <span class="inline-flex items-center gap-1 text-emerald-700">
                                    <i class="fas fa-cube text-emerald-500"></i> Bahan: Rp <?php echo e(number_format($materialTotal, 0, ',', '.')); ?>

                                </span>
                                <span class="inline-flex items-center gap-1 text-blue-700">
                                    <i class="fas fa-cog text-blue-500"></i> Sparepart: Rp <?php echo e(number_format($sparepartTotal, 0, ',', '.')); ?>

                                </span>
                            </div>
                        </td>
                        <td class="px-4 py-3 text-right font-bold text-gray-900 dark:text-white">
                            Total: Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?>

                        </td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        <?php else: ?>
        <div class="p-8 text-center">
            <div class="w-14 h-14 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                <i class="fas fa-inbox text-2xl text-gray-400"></i>
            </div>
            <p class="text-gray-500">Belum ada bahan atau sparepart ditambahkan</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Labor Cost -->
    <?php if($laborTotal > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-users text-orange-600"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900 dark:text-white">Biaya Tenaga Kerja (Labor)</h3>
                    <p class="text-xs text-gray-500">Upah untuk <?php echo e($orderQty); ?> unit produk</p>
                </div>
            </div>
            <div class="text-right">
                <p class="text-xl font-bold text-orange-600">Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?></p>
                <p class="text-xs text-gray-500">Per unit: Rp <?php echo e(number_format($laborTotal / max($orderQty, 1), 0, ',', '.')); ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Total Cost Summary - Clean Style -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-5">
        <div class="flex items-center justify-between">
            <div>
                <div class="flex items-center gap-2 mb-1">
                    <div class="w-8 h-8 rounded-lg bg-indigo-100 flex items-center justify-center">
                        <i class="fas fa-calculator text-indigo-600 text-sm"></i>
                    </div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Biaya Produksi</p>
                </div>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">Rp <?php echo e(number_format($actualTotal, 0, ',', '.')); ?></p>
                <p class="text-xs text-gray-500 mt-1">
                    <span class="inline-flex items-center gap-1"><i class="fas fa-cube text-emerald-500"></i> Langsung: Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?></span>
                    <span class="mx-2">•</span>
                    <span class="inline-flex items-center gap-1"><i class="fas fa-users text-blue-500"></i> Labor: Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?></span>
                </p>
            </div>
            <div class="text-right border-l border-gray-200 dark:border-gray-600 pl-5">
                <p class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-1">Per Unit</p>
                <p class="text-xl font-bold text-indigo-600">Rp <?php echo e(number_format($actualTotal / max($orderQty, 1), 0, ',', '.')); ?></p>
            </div>
        </div>
    </div>

    <!-- Catatan Teknisi -->
    <?php if($production->notes): ?>
    <div class="bg-amber-50 border border-amber-200 rounded-lg p-4">
        <h3 class="text-sm font-semibold text-amber-800 mb-2 flex items-center gap-2">
            <i class="fas fa-sticky-note text-amber-600"></i> Catatan dari Teknisi
        </h3>
        <p class="text-sm text-amber-700"><?php echo e($production->notes); ?></p>
    </div>
    <?php endif; ?>

    <!-- Action Buttons -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4">
        <div class="flex flex-wrap gap-3 justify-between items-center">
            <a href="<?php echo e(route('supervisor.productions.index')); ?>" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium transition-colors">
                <i class="fas fa-arrow-left mr-1"></i> Kembali
            </a>
            
            <?php if($production->planning_status === 'pending_approval'): ?>
            <div class="flex gap-2">
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveProductionFromBtn(this)"
                        class="px-5 py-2.5 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-check mr-1"></i> Setujui Planning
                </button>
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectProductionFromBtn(this)"
                        class="px-5 py-2.5 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-redo mr-1"></i> Minta Revisi
                </button>
            </div>
            <?php elseif($production->completion_status === 'pending_approval'): ?>
            <div class="flex gap-2">
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveCompletionFromBtn(this)"
                        class="px-5 py-2.5 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-check-double mr-1"></i> Setujui Penyelesaian
                </button>
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectCompletionFromBtn(this)"
                        class="px-5 py-2.5 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-redo mr-1"></i> Minta Revisi
                </button>
            </div>
            <?php else: ?>
            <span class="px-4 py-2 bg-gray-100 text-gray-600 rounded-lg text-sm">
                <?php if($production->planning_status === 'approved'): ?>
                    <i class="fas fa-check-circle text-green-500 mr-1"></i> Planning sudah disetujui
                <?php elseif($production->status === 'selesai'): ?>
                    <i class="fas fa-check-double text-green-500 mr-1"></i> Produksi sudah selesai
                <?php else: ?>
                    <i class="fas fa-info-circle mr-1"></i> Tidak ada aksi yang diperlukan
                <?php endif; ?>
            </span>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal Persetujuan Planning -->
<div id="approvalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-circle"></i> Setujui Planning
                </h3>
            </div>
            <form id="approvalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeApprovalModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Planning -->
<div id="rejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Planning
                </h3>
            </div>
            <form id="rejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeRejectionModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Persetujuan Penyelesaian -->
<div id="completionApprovalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-double"></i> Setujui Penyelesaian
                </h3>
            </div>
            <form id="completionApprovalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionApprovalModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Penyelesaian -->
<div id="completionRejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Penyelesaian
                </h3>
            </div>
            <form id="completionRejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionRejectionModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Planning Modal Functions
function approveProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('approvalForm').action = `/supervisor/productions/${id}/approve`;
    document.getElementById('approvalModal').classList.remove('hidden');
}

function rejectProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('rejectionForm').action = `/supervisor/productions/${id}/reject`;
    document.getElementById('rejectionModal').classList.remove('hidden');
}

function closeApprovalModal() {
    document.getElementById('approvalModal').classList.add('hidden');
}

function closeRejectionModal() {
    document.getElementById('rejectionModal').classList.add('hidden');
}

// Completion Modal Functions
function approveCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionApprovalForm').action = `/supervisor/productions/${id}/approve-completion`;
    document.getElementById('completionApprovalModal').classList.remove('hidden');
}

function rejectCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionRejectionForm').action = `/supervisor/productions/${id}/reject-completion`;
    document.getElementById('completionRejectionModal').classList.remove('hidden');
}

function closeCompletionApprovalModal() {
    document.getElementById('completionApprovalModal').classList.add('hidden');
}

function closeCompletionRejectionModal() {
    document.getElementById('completionRejectionModal').classList.add('hidden');
}

// Close on backdrop click
['approvalModal', 'rejectionModal', 'completionApprovalModal', 'completionRejectionModal'].forEach(id => {
    const el = document.getElementById(id);
    if (el) {
        el.addEventListener('click', function(e) {
            if (e.target === this) {
                this.classList.add('hidden');
            }
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/productions/show.blade.php ENDPATH**/ ?>