

<?php $__env->startSection('title', 'Edit Kategori'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.categories.index')); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Edit Kategori</h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <div class="p-6">

        <form action="<?php echo e(route('admin.categories.update', $category->id)); ?>" method="POST" enctype="multipart/form-data"
            class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <!-- Nama -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Nama Kategori <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" id="name" value="<?php echo e(old('name', $category->name)); ?>" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                    placeholder="Masukkan nama kategori">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Tipe -->
            <div>
                <label for="type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Tipe <span class="text-red-500">*</span>
                </label>
                <select name="type" id="type" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="service" <?php echo e(old('type', $category->type) == 'service' ? 'selected' : ''); ?>>Jasa</option>
                </select>
                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Parent Category -->
            <div>
                <label for="parent_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Kategori Besar (Parent) <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional - Kosongkan untuk membuat kategori besar)</span>
                </label>
                <select name="parent_id" id="parent_id"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">-- Pilih Kategori Besar (atau kosongkan) --</option>
                    <?php $__currentLoopData = $parentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($parent->id); ?>" <?php echo e(old('parent_id', $category->parent_id) == $parent->id ? 'selected' : ''); ?>>
                            <?php echo e($parent->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    <i class="fas fa-info-circle mr-1"></i>
                    Kosongkan untuk membuat kategori besar baru, atau pilih kategori besar untuk membuat sub kategori.
                </p>
                <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Gambar -->
            <div>
                <label for="image" id="imageLabel" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Gambar Kategori <span id="imageRequired" class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <div class="relative">
                    <input type="file" name="image" id="image" accept="image/*"
                        class="w-full px-4 py-3 text-sm text-gray-700 dark:text-gray-300 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 dark:file:bg-blue-900 dark:file:text-blue-200 <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                </div>
                <p id="imageHelpText" class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    <i class="fas fa-info-circle mr-1"></i>
                    <span id="imageHelpContent">Gambar opsional untuk kategori besar.</span>
                </p>
                <?php if($category->image): ?>
                    <p class="mt-1 text-xs text-green-600 dark:text-green-400">
                        <i class="fas fa-check-circle mr-1"></i>
                        Gambar saat ini sudah ada. Upload gambar baru untuk menggantinya.
                    </p>
                <?php endif; ?>
                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <!-- Preview -->
                <div class="mt-4">
                    <div class="flex items-center justify-center w-48 h-48 bg-gray-50 dark:bg-gray-700/50 rounded-lg border-2 <?php echo e($category->image ? 'border-solid border-gray-200 dark:border-gray-600' : 'border-dashed border-gray-300 dark:border-gray-600'); ?>" id="previewContainer">
                        <img id="previewImage" class="max-w-full max-h-full object-contain rounded-lg" 
                             src="<?php echo e($category->image ? asset('uploads/' . $category->image) : ''); ?>"
                             style="<?php echo e($category->image ? 'display: block; background: transparent;' : 'display: none; background: transparent;'); ?>">
                        <div id="previewPlaceholder" class="text-center" style="<?php echo e($category->image ? 'display: none;' : 'display: block;'); ?>">
                            <i class="fas fa-image text-4xl text-gray-400 dark:text-gray-500 mb-2"></i>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Preview gambar</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="<?php echo e(route('admin.categories.index')); ?>"
                    class="px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Perbarui Kategori</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Script Preview Gambar & Dynamic Label -->
    <script>
        const parentSelect = document.getElementById('parent_id');
        const imageInput = document.getElementById('image');
        const imageLabel = document.getElementById('imageLabel');
        const imageRequired = document.getElementById('imageRequired');
        const imageHelpContent = document.getElementById('imageHelpContent');
        const hasExistingImage = <?php echo e($category->image ? 'true' : 'false'); ?>;

        // Function untuk update label gambar berdasarkan pilihan parent
        function updateImageLabel() {
            const hasParent = parentSelect.value !== '';
            
            if (hasParent) {
                // Sub kategori - gambar wajib (kecuali sudah ada gambar sebelumnya)
                if (!hasExistingImage) {
                    imageRequired.innerHTML = '<span class="text-red-500">*</span> <span class="text-gray-500 dark:text-gray-400">(Wajib)</span>';
                    imageInput.setAttribute('required', 'required');
                    imageHelpContent.textContent = 'Gambar wajib untuk sub kategori karena akan ditampilkan di halaman depan.';
                } else {
                    imageRequired.innerHTML = '<span class="text-gray-500 dark:text-gray-400 text-sm">(Wajib - sudah ada gambar)</span>';
                    imageInput.removeAttribute('required');
                    imageHelpContent.textContent = 'Gambar sudah ada. Upload gambar baru untuk menggantinya.';
                }
                imageHelpContent.classList.remove('text-gray-500');
                imageHelpContent.classList.add('text-blue-600', 'dark:text-blue-400');
            } else {
                // Kategori besar - gambar opsional
                imageRequired.innerHTML = '<span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>';
                imageInput.removeAttribute('required');
                imageHelpContent.textContent = 'Gambar opsional untuk kategori besar.';
                imageHelpContent.classList.remove('text-blue-600', 'dark:text-blue-400');
                imageHelpContent.classList.add('text-gray-500');
            }
        }

        // Event listener untuk perubahan parent
        parentSelect.addEventListener('change', updateImageLabel);

        // Initialize label saat page load
        updateImageLabel();

        // Preview gambar
        imageInput.addEventListener('change', function(event) {
            const file = event.target.files[0];
            const preview = document.getElementById('previewImage');
            const placeholder = document.getElementById('previewPlaceholder');
            const container = document.getElementById('previewContainer');

            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    preview.style.background = 'transparent';
                    placeholder.style.display = 'none';
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                };
                reader.readAsDataURL(file);
            } else {
                // Jika tidak ada file yang dipilih, kembali ke gambar asli atau placeholder
                const originalImage = '<?php echo e($category->image ? asset("uploads/" . $category->image) : ""); ?>';
                if (originalImage) {
                    preview.src = originalImage;
                    preview.style.display = 'block';
                    preview.style.background = 'transparent';
                    placeholder.style.display = 'none';
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                } else {
                    preview.src = '';
                    preview.style.display = 'none';
                    placeholder.style.display = 'block';
                    container.classList.add('border-dashed');
                    container.classList.remove('border-solid');
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/categories/edit.blade.php ENDPATH**/ ?>