

<?php $__env->startSection('title', 'Persetujuan Produksi - Supervisor'); ?>

<?php $__env->startPush('styles'); ?>
<style>
[x-cloak] { display: none !important; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-4" x-data="{ activeTab: 'planning' }">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white">Persetujuan Produksi</h1>
            <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1">Review dan setujui planning & penyelesaian produksi dari teknisi</p>
        </div>
    </div>

    <!-- Tab Navigation -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-1.5 inline-flex gap-1">
        <button @click="activeTab = 'planning'" 
                class="px-4 py-2.5 rounded-lg font-medium text-sm transition-all flex items-center gap-2"
                :class="activeTab === 'planning' ? 'bg-blue-600 text-white shadow-sm' : 'bg-white border border-gray-300 text-gray-700 hover:bg-gray-50'">
            <i class="fas fa-clipboard-list"></i>
            <span>Planning</span>
            <?php if($pendingPlanning->count() > 0): ?>
            <span class="px-2 py-0.5 text-xs font-bold rounded-full" :class="activeTab === 'planning' ? 'bg-white text-blue-600' : 'bg-blue-600 text-white'"><?php echo e($pendingPlanning->count()); ?></span>
            <?php endif; ?>
        </button>
        <button @click="activeTab = 'completion'" 
                class="px-4 py-2.5 rounded-lg font-medium text-sm transition-all flex items-center gap-2"
                :class="activeTab === 'completion' ? 'bg-purple-500 text-white shadow-sm' : 'bg-white border border-gray-300 text-gray-700 hover:bg-gray-50'">
            <i class="fas fa-check-double"></i>
            <span>Penyelesaian</span>
            <?php if($pendingCompletion->count() > 0): ?>
            <span class="px-2 py-0.5 text-xs font-bold rounded-full" :class="activeTab === 'completion' ? 'bg-white text-purple-600' : 'bg-purple-500 text-white'"><?php echo e($pendingCompletion->count()); ?></span>
            <?php endif; ?>
        </button>
    </div>

    <!-- Alert: Planning Pending > 24 Jam -->
    <?php if($pendingPlanningOverdue->count() > 0): ?>
    <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
        <div class="flex items-start gap-3">
            <div class="w-8 h-8 bg-red-100 rounded-full flex items-center justify-center flex-shrink-0">
                <i class="fas fa-exclamation-triangle text-red-600"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-sm font-semibold text-red-800 mb-1">
                    Peringatan: <?php echo e($pendingPlanningOverdue->count()); ?> Planning Menunggu Lebih dari 24 Jam
                </h3>
                <p class="text-sm text-red-700 mb-2">
                    Terdapat planning yang sudah menunggu persetujuan lebih dari 24 jam. Mohon segera ditinjau.
                </p>
                <div class="flex flex-wrap gap-2">
                    <?php $__currentLoopData = $pendingPlanningOverdue->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $overdue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('supervisor.productions.show', $overdue)); ?>" 
                       class="text-xs text-red-600 hover:text-red-800 underline">
                        #<?php echo e($overdue->id); ?> (<?php echo e($overdue->submitted_at->diffForHumans()); ?>)
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($pendingPlanningOverdue->count() > 5): ?>
                    <span class="text-xs text-red-600">dan <?php echo e($pendingPlanningOverdue->count() - 5); ?> lainnya...</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Alert: Produksi Melewati Estimasi -->
    <?php if($overdueProductions->count() > 0): ?>
    <div class="bg-amber-50 border-l-4 border-amber-500 p-4 rounded-r-lg">
        <div class="flex items-start gap-3">
            <div class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center flex-shrink-0">
                <i class="fas fa-clock text-amber-600"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-sm font-semibold text-amber-800 mb-1">
                    Peringatan: <?php echo e($overdueProductions->count()); ?> Produksi Melewati Estimasi
                </h3>
                <p class="text-sm text-amber-700 mb-2">
                    Terdapat produksi yang sudah melewati estimasi waktu selesai. Mohon ditinjau.
                </p>
                <div class="flex flex-wrap gap-2">
                    <?php $__currentLoopData = $overdueProductions->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $overdue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('supervisor.productions.show', $overdue)); ?>" 
                       class="text-xs text-amber-600 hover:text-amber-800 underline">
                        #<?php echo e($overdue->id); ?> - <?php echo e(Str::limit($overdue->product->product_title ?? 'N/A', 20)); ?>

                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Pending Planning Section -->
    <div x-show="activeTab === 'planning'" x-cloak>
    <?php if($pendingPlanning->count() > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-base font-semibold text-gray-900 dark:text-white flex items-center gap-2">
                <i class="fas fa-clipboard-list text-amber-500"></i>
                Menunggu Persetujuan Planning
            </h2>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">ID</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Produk</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Pesanan</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Teknisi</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Total Biaya</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Diajukan</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                <?php $__currentLoopData = $pendingPlanning; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
                    $materialTotal = $production->total_material_cost ?? 0;
                    $sparepartTotal = $production->total_sparepart_cost ?? 0;
                    $directTotal = $materialTotal + $sparepartTotal;
                    $laborTotal = $production->labor_cost ?? 0;
                    $actualTotal = $directTotal + $laborTotal;
                    $isOverdue = $production->submitted_at && $production->submitted_at->lt(now()->subDay());
                ?>
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors <?php echo e($isOverdue ? 'bg-red-50/30' : ''); ?>">
                        <td class="px-4 py-3">
                            <div class="flex items-center gap-2">
                                <span class="font-bold text-gray-900 dark:text-white">#<?php echo e($production->id); ?></span>
                                <?php if($isOverdue): ?>
                                <span class="px-1.5 py-0.5 text-[10px] font-bold bg-red-100 text-red-700 rounded">
                                    TERLAMBAT
                                </span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="font-medium text-gray-900 dark:text-white text-sm">
                                <?php echo e(Str::limit($production->product->product_title ?? 'N/A', 30)); ?>

                            </div>
                            <div class="text-xs text-gray-500"><?php echo e($orderQty); ?> unit</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900 dark:text-white">#<?php echo e($production->order->id ?? 'N/A'); ?></div>
                            <div class="text-xs text-gray-500"><?php echo e(Str::limit($production->order->customer_name ?? 'N/A', 15)); ?></div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900 dark:text-white"><?php echo e(Str::limit($production->teknisi->name ?? 'N/A', 18)); ?></div>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">Rp <?php echo e(number_format($actualTotal, 0, ',', '.')); ?></div>
                            <div class="text-xs text-gray-500"><?php echo e($production->productionMaterials->count() + $production->productionSpareparts->count()); ?> item</div>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <div class="text-xs text-gray-600"><?php echo e($production->submitted_at?->format('d/m/Y') ?? '-'); ?></div>
                            <?php if($production->submitted_at): ?>
                            <div class="text-xs text-gray-400"><?php echo e($production->submitted_at->diffForHumans()); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex justify-center items-center gap-2">
                                <a href="<?php echo e(route('supervisor.productions.show', $production->id)); ?>" 
                                   class="w-9 h-9 flex items-center justify-center text-blue-600 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors border border-blue-200"
                                   title="Lihat Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveProductionFromBtn(this)"
                                        class="w-9 h-9 flex items-center justify-center bg-green-500 hover:bg-green-600 text-white rounded-lg transition-colors shadow-sm"
                                        title="Setujui">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectProductionFromBtn(this)"
                                        class="w-9 h-9 flex items-center justify-center bg-orange-500 hover:bg-orange-600 text-white rounded-lg transition-colors shadow-sm"
                                        title="Revisi">
                                    <i class="fas fa-undo"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php else: ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-8 text-center">
        <div class="w-14 h-14 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-3">
            <i class="fas fa-clipboard-check text-2xl text-emerald-500"></i>
        </div>
        <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Tidak Ada Planning Menunggu</h3>
        <p class="text-sm text-gray-500">Semua planning produksi sudah diproses</p>
    </div>
    <?php endif; ?>
    </div>

    <!-- Pending Completion Section -->
    <div x-show="activeTab === 'completion'" x-cloak>
    <?php if($pendingCompletion->count() > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-base font-semibold text-gray-900 dark:text-white flex items-center gap-2">
                <i class="fas fa-check-double text-purple-500"></i>
                Menunggu Persetujuan Penyelesaian
            </h2>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">ID</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Produk</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Pesanan</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Teknisi</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Total Biaya</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Selesai</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                <?php $__currentLoopData = $pendingCompletion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $orderQty2 = $production->quantity ?? $production->order->quantity ?? 1;
                    $materialTotal2 = $production->total_material_cost ?? 0;
                    $sparepartTotal2 = $production->total_sparepart_cost ?? 0;
                    $directTotal2 = $materialTotal2 + $sparepartTotal2;
                    $laborTotal2 = $production->labor_cost ?? 0;
                    $actualTotal2 = $directTotal2 + $laborTotal2;
                ?>
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors">
                        <td class="px-4 py-3">
                            <span class="font-bold text-gray-900 dark:text-white">#<?php echo e($production->id); ?></span>
                        </td>
                        <td class="px-4 py-3">
                            <div class="font-medium text-gray-900 dark:text-white text-sm">
                                <?php echo e(Str::limit($production->product->product_title ?? 'N/A', 30)); ?>

                            </div>
                            <div class="text-xs text-gray-500"><?php echo e($orderQty2); ?> unit</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900 dark:text-white">#<?php echo e($production->order->id ?? 'N/A'); ?></div>
                            <div class="text-xs text-gray-500"><?php echo e(Str::limit($production->order->customer_name ?? 'N/A', 15)); ?></div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900 dark:text-white"><?php echo e(Str::limit($production->teknisi->name ?? 'N/A', 18)); ?></div>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">Rp <?php echo e(number_format($actualTotal2, 0, ',', '.')); ?></div>
                            <?php if($laborTotal2 > 0): ?>
                            <div class="text-xs text-gray-500">Upah: Rp <?php echo e(number_format($laborTotal2, 0, ',', '.')); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <div class="text-xs text-gray-600"><?php echo e($production->completed_at?->format('d/m/Y') ?? '-'); ?></div>
                            <?php if($production->completed_at): ?>
                            <div class="text-xs text-gray-400"><?php echo e($production->completed_at->diffForHumans()); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex justify-center items-center gap-2">
                                <a href="<?php echo e(route('supervisor.productions.show', $production->id)); ?>" 
                                   class="w-9 h-9 flex items-center justify-center text-blue-600 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors border border-blue-200"
                                   title="Lihat Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveCompletionFromBtn(this)"
                                        class="w-9 h-9 flex items-center justify-center bg-green-500 hover:bg-green-600 text-white rounded-lg transition-colors shadow-sm"
                                        title="Setujui">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectCompletionFromBtn(this)"
                                        class="w-9 h-9 flex items-center justify-center bg-orange-500 hover:bg-orange-600 text-white rounded-lg transition-colors shadow-sm"
                                        title="Revisi">
                                    <i class="fas fa-undo"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php else: ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-8 text-center">
        <div class="w-14 h-14 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-3">
            <i class="fas fa-check-circle text-2xl text-emerald-500"></i>
        </div>
        <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Tidak Ada Penyelesaian Menunggu</h3>
        <p class="text-sm text-gray-500">Semua penyelesaian produksi sudah diproses</p>
    </div>
    <?php endif; ?>
    </div>
</div>

<!-- Modal Persetujuan Planning -->
<div id="approvalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-circle"></i> Setujui Planning
                </h3>
            </div>
            <form id="approvalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeApprovalModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Planning -->
<div id="rejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Planning
                </h3>
            </div>
            <form id="rejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeRejectionModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Persetujuan Penyelesaian -->
<div id="completionApprovalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-double"></i> Setujui Penyelesaian
                </h3>
            </div>
            <form id="completionApprovalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionApprovalModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Penyelesaian -->
<div id="completionRejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Penyelesaian
                </h3>
            </div>
            <form id="completionRejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionRejectionModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Toast notification modern
function showToast(message, type = 'success') {
    const styles = {
        success: { border: '#10b981', bg: '#ecfdf5', text: '#065f46', icon: 'check-circle', iconColor: '#10b981' },
        error: { border: '#ef4444', bg: '#fef2f2', text: '#991b1b', icon: 'times-circle', iconColor: '#ef4444' },
        warning: { border: '#f59e0b', bg: '#fffbeb', text: '#92400e', icon: 'exclamation-triangle', iconColor: '#f59e0b' },
        info: { border: '#3b82f6', bg: '#eff6ff', text: '#1e40af', icon: 'info-circle', iconColor: '#3b82f6' }
    };
    const s = styles[type] || styles.success;
    
    const toast = document.createElement('div');
    toast.style.cssText = `
        position: fixed; top: 20px; right: 20px; z-index: 9999;
        display: flex; align-items: center; gap: 12px;
        padding: 14px 20px; border-radius: 12px;
        background: ${s.bg}; border-left: 4px solid ${s.border};
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transform: translateX(120%); transition: transform 0.3s ease;
    `;
    toast.innerHTML = `
        <i class="fas fa-${s.icon}" style="color: ${s.iconColor}; font-size: 18px;"></i>
        <span style="color: ${s.text}; font-weight: 500; font-size: 14px;">${message}</span>
        <button onclick="this.parentElement.remove()" style="margin-left: 8px; color: ${s.text}; opacity: 0.5; cursor: pointer; background: none; border: none;">
            <i class="fas fa-times"></i>
        </button>
    `;
    document.body.appendChild(toast);
    
    requestAnimationFrame(() => { toast.style.transform = 'translateX(0)'; });
    setTimeout(() => {
        toast.style.transform = 'translateX(120%)';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}

// Planning Modal Functions
function approveProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('approvalForm').action = `/supervisor/productions/${id}/approve`;
    document.getElementById('approvalModal').classList.remove('hidden');
}

function rejectProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('rejectionForm').action = `/supervisor/productions/${id}/reject`;
    document.getElementById('rejectionModal').classList.remove('hidden');
}

function closeApprovalModal() {
    document.getElementById('approvalModal').classList.add('hidden');
}

function closeRejectionModal() {
    document.getElementById('rejectionModal').classList.add('hidden');
}

// Completion Modal Functions
function approveCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionApprovalForm').action = `/supervisor/productions/${id}/approve-completion`;
    document.getElementById('completionApprovalModal').classList.remove('hidden');
}

function rejectCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionRejectionForm').action = `/supervisor/productions/${id}/reject-completion`;
    document.getElementById('completionRejectionModal').classList.remove('hidden');
}

function closeCompletionApprovalModal() {
    document.getElementById('completionApprovalModal').classList.add('hidden');
}

function closeCompletionRejectionModal() {
    document.getElementById('completionRejectionModal').classList.add('hidden');
}

// Close on backdrop click
['approvalModal', 'rejectionModal', 'completionApprovalModal', 'completionRejectionModal'].forEach(id => {
    const el = document.getElementById(id);
    if (el) {
        el.addEventListener('click', function(e) {
            if (e.target === this) {
                this.classList.add('hidden');
            }
        });
    }
});

// Form submission dengan notifikasi
document.querySelectorAll('#approvalForm, #completionApprovalForm').forEach(form => {
    form.addEventListener('submit', function() {
        setTimeout(() => showToast('Planning berhasil disetujui!', 'success'), 500);
    });
});

document.querySelectorAll('#rejectionForm, #completionRejectionForm').forEach(form => {
    form.addEventListener('submit', function() {
        setTimeout(() => showToast('Permintaan revisi berhasil dikirim', 'warning'), 500);
    });
});

// Show flash message if exists
<?php if(session('success')): ?>
    showToast('<?php echo e(session('success')); ?>', 'success');
<?php endif; ?>
<?php if(session('error')): ?>
    showToast('<?php echo e(session('error')); ?>', 'error');
<?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/productions/index.blade.php ENDPATH**/ ?>