<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Penawaran Baru - POLJAM TECH</title>
    <style>
        /* Reset styles */
        body, table, td, p, a, li, blockquote {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        table, td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        img {
            -ms-interpolation-mode: bicubic;
            border: 0;
            outline: none;
            text-decoration: none;
        }
        
        /* Main styles */
        body {
            margin: 0;
            padding: 0;
            width: 100% !important;
            height: 100% !important;
            background-color: #f3f4f6;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }
        
        .email-wrapper {
            width: 100%;
            background-color: #f3f4f6;
            padding: 20px 0;
        }
        
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        /* Header */
        .email-header {
            background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
            padding: 40px 30px;
            text-align: center;
        }
        
        .email-header h1 {
            margin: 0;
            color: #ffffff;
            font-size: 28px;
            font-weight: 700;
            letter-spacing: -0.5px;
        }
        
        .email-header .badge {
            display: inline-block;
            margin-top: 15px;
            padding: 8px 16px;
            background-color: rgba(255, 255, 255, 0.2);
            color: #ffffff;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        /* Content */
        .email-content {
            padding: 40px 30px;
        }
        
        .email-title {
            font-size: 24px;
            font-weight: 700;
            color: #111827;
            margin: 0 0 10px 0;
            line-height: 1.3;
        }
        
        .email-subtitle {
            font-size: 16px;
            color: #6b7280;
            margin: 0 0 30px 0;
            line-height: 1.5;
        }
        
        /* Info Card */
        .info-card {
            background-color: #f9fafb;
            border-left: 4px solid #8b5cf6;
            border-radius: 8px;
            padding: 24px;
            margin: 25px 0;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            min-width: 140px;
        }
        
        .info-value {
            font-size: 14px;
            color: #111827;
            text-align: right;
            font-weight: 500;
        }
        
        .info-value.highlight {
            color: #8b5cf6;
            font-weight: 700;
            font-size: 16px;
        }
        
        /* Request Type Badge */
        .type-badge {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .type-badge.katalog {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        .type-badge.custom-addon {
            background-color: #fef3c7;
            color: #92400e;
        }
        
        .type-badge.custom-new {
            background-color: #fee2e2;
            color: #991b1b;
        }
        
        /* Addons Table */
        .addons-box {
            background-color: #fef3c7;
            border-left: 4px solid #f59e0b;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .addons-box .label {
            font-size: 12px;
            font-weight: 600;
            color: #92400e;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 12px;
        }
        
        .addons-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        .addons-table th {
            background-color: #fbbf24;
            color: #78350f;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            padding: 8px 12px;
            text-align: left;
            border-bottom: 2px solid #f59e0b;
        }
        
        .addons-table td {
            padding: 10px 12px;
            font-size: 13px;
            color: #78350f;
            border-bottom: 1px solid #fde68a;
        }
        
        .addons-table tr:last-child td {
            border-bottom: none;
        }
        
        /* Message Box */
        .message-box {
            background-color: #fef3c7;
            border-left: 4px solid #f59e0b;
            border-radius: 8px;
            padding: 20px;
            margin: 25px 0;
        }
        
        .message-box .label {
            font-size: 12px;
            font-weight: 600;
            color: #92400e;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 10px;
        }
        
        .message-box .content {
            font-size: 14px;
            color: #78350f;
            line-height: 1.6;
            white-space: pre-wrap;
        }
        
        /* Button */
        .email-button {
            display: inline-block;
            margin-top: 30px;
            padding: 14px 32px;
            background-color: #8b5cf6;
            color: #ffffff !important;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 16px;
            text-align: center;
        }
        
        .email-button:hover {
            background-color: #7c3aed;
        }
        
        /* Footer */
        .email-footer {
            background-color: #f9fafb;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
        }
        
        .email-footer p {
            margin: 8px 0;
            font-size: 13px;
            color: #6b7280;
            line-height: 1.6;
        }
        
        .email-footer .company-name {
            font-weight: 600;
            color: #374151;
            font-size: 14px;
        }
        
        /* Mobile Responsive */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                border-radius: 0 !important;
            }
            
            .email-header,
            .email-content,
            .email-footer {
                padding: 25px 20px !important;
            }
            
            .email-header h1 {
                font-size: 24px !important;
            }
            
            .email-title {
                font-size: 20px !important;
            }
            
            .info-row {
                flex-direction: column;
                gap: 5px;
            }
            
            .info-label {
                min-width: auto;
            }
            
            .info-value {
                text-align: left;
            }
            
            .email-button {
                display: block;
                width: 100%;
                padding: 16px;
            }
            
            .addons-table {
                font-size: 11px;
            }
            
            .addons-table th,
            .addons-table td {
                padding: 8px;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="email-container">
            <!-- Header -->
            <div class="email-header">
                <h1>POLJAM TECH</h1>
                <span class="badge">Penawaran Baru</span>
            </div>
            
            <!-- Content -->
            <div class="email-content">
                <h2 class="email-title">Ada Penawaran Baru Masuk!</h2>
                <p class="email-subtitle">Seseorang telah mengajukan penawaran untuk produk di website Anda.</p>
                
                <?php
                    // Parse message untuk request type dan addons
                    $raw = $inquiry->message ?? '';
                    $lines = preg_split("/(\r\n|\n|\r)/", $raw);
                    $type = null;
                    $addons = [];
                    $hasAddonsLine = false;
                    
                    if (!empty($lines)) {
                        $first = $lines[0] ?? '';
                        $second = $lines[1] ?? '';
                        
                        if (substr($first, 0, 14) === '[REQUEST_TYPE]') {
                            $type = trim(substr($first, 14));
                        }
                        
                        if (substr($second, 0, 8) === '[ADDONS]') {
                            $hasAddonsLine = true;
                            $matches = [];
                            if (preg_match('/^\[ADDONS\]\s*(\[[\s\S]*\])$/', $second, $matches)) {
                                $decoded = json_decode($matches[1], true);
                                if (is_array($decoded)) {
                                    $addons = $decoded;
                                }
                            }
                        }
                    }
                    
                    $startIdx = 0;
                    if ($type) { $startIdx++; }
                    if ($hasAddonsLine) { $startIdx++; }
                    if (!empty($lines) && isset($lines[$startIdx]) && trim($lines[$startIdx]) === '') { $startIdx++; }
                    $plainMessage = implode("\n", array_slice($lines, $startIdx));
                    
                    $typeLabel = $type === 'custom_addon' ? 'Custom Add-on' : ($type === 'custom_new' ? 'Custom Baru' : ($type === 'template' ? 'Katalog' : null));
                    $typeClass = $type === 'custom_addon' ? 'custom-addon' : ($type === 'custom_new' ? 'custom-new' : 'katalog');
                ?>
                
                <!-- Inquiry Info Card -->
                <div class="info-card">
                    <div class="info-row">
                        <span class="info-label">ID Penawaran</span>
                        <span class="info-value highlight">#<?php echo e($inquiry->id); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Tracking Code</span>
                        <span class="info-value" style="font-family: monospace;"><?php echo e($inquiry->tracking_code ?? '-'); ?></span>
                    </div>
                    <?php if($typeLabel): ?>
                    <div class="info-row">
                        <span class="info-label">Tipe Permintaan</span>
                        <span class="info-value">
                            <span class="type-badge <?php echo e($typeClass); ?>"><?php echo e($typeLabel); ?></span>
                        </span>
                    </div>
                    <?php endif; ?>
                    <div class="info-row">
                        <span class="info-label">Nama Customer</span>
                        <span class="info-value"><?php echo e($inquiry->name); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Email</span>
                        <span class="info-value"><?php echo e($inquiry->email); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Telepon</span>
                        <span class="info-value"><?php echo e($inquiry->phone ?? '-'); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Produk</span>
                        <span class="info-value"><?php echo e($inquiry->product->product_title ?? 'N/A'); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Status</span>
                        <span class="info-value"><?php echo e(ucfirst(str_replace('_', ' ', $inquiry->status ?? 'Pending'))); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Tanggal</span>
                        <span class="info-value"><?php echo e($inquiry->created_at->format('d/m/Y H:i')); ?></span>
                    </div>
                </div>
                
                <!-- Addons Box (jika ada) -->
                <?php if(!empty($addons) && count($addons) > 0): ?>
                <div class="addons-box">
                    <div class="label">Spesifikasi Tambahan (Custom Add-ons)</div>
                    <table class="addons-table">
                        <thead>
                            <tr>
                                <th>Nama</th>
                                <th>Nilai</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e(is_array($addon) ? ($addon['name'] ?? '-') : '-'); ?></strong></td>
                                <td><?php echo e(is_array($addon) ? ($addon['value'] ?? '-') : '-'); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
                
                <!-- Message Box -->
                <?php if(!empty($plainMessage)): ?>
                <div class="message-box">
                    <div class="label">Pesan dari Customer</div>
                    <div class="content"><?php echo e($plainMessage); ?></div>
                </div>
                <?php endif; ?>
                
                <!-- Action Button -->
                <div style="text-align: center;">
                    <a href="<?php echo e(route('admin.product-inquiries.index')); ?>" class="email-button">
                        Lihat Detail Penawaran
                    </a>
                </div>
            </div>
            
            <!-- Footer -->
            <div class="email-footer">
                <p class="company-name">POLJAM TECH</p>
                <p>Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</p>
                <p>Email ini dikirim secara otomatis dari sistem. Jangan balas email ini.</p>
                <p style="margin-top: 15px; color: #9ca3af; font-size: 12px;">
                    &copy; <?php echo e(date('Y')); ?> POLJAM TECH. All rights reserved.
                </p>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/emails/admin/new-inquiry.blade.php ENDPATH**/ ?>