<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['icon' => 'fas fa-inbox', 'title', 'message', 'action' => null, 'image' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['icon' => 'fas fa-inbox', 'title', 'message', 'action' => null, 'image' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="text-center py-12 px-4">
    <?php if($image): ?>
        <img src="<?php echo e($image); ?>" alt="Empty State" class="w-32 h-32 mx-auto mb-4 opacity-50">
    <?php else: ?>
        <div class="w-20 h-20 mx-auto bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
            <i class="<?php echo e($icon); ?> text-4xl text-gray-400 dark:text-gray-500"></i>
        </div>
    <?php endif; ?>
    
    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2"><?php echo e($title); ?></h3>
    <p class="text-gray-600 dark:text-gray-400 mb-6 max-w-md mx-auto"><?php echo e($message); ?></p>
    
    <?php if($action): ?>
        <div class="flex flex-col sm:flex-row gap-3 justify-center items-center">
            <?php if(isset($action['primary'])): ?>
                <a href="<?php echo e($action['primary']['url']); ?>" 
                   class="inline-flex items-center px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium transition-all duration-200 shadow-md hover:shadow-lg transform hover:-translate-y-0.5">
                    <i class="<?php echo e($action['primary']['icon'] ?? 'fas fa-plus'); ?> mr-2"></i>
                    <?php echo e($action['primary']['label']); ?>

                </a>
            <?php endif; ?>
            <?php if(isset($action['secondary'])): ?>
                <a href="<?php echo e($action['secondary']['url']); ?>" 
                   class="inline-flex items-center px-6 py-3 bg-gray-100 hover:bg-gray-200 dark:bg-gray-700 dark:hover:bg-gray-600 text-gray-900 dark:text-white rounded-lg font-medium transition-all duration-200">
                    <i class="<?php echo e($action['secondary']['icon'] ?? 'fas fa-info'); ?> mr-2"></i>
                    <?php echo e($action['secondary']['label']); ?>

                </a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/components/empty-state.blade.php ENDPATH**/ ?>