

<?php $__env->startSection('title', 'Detail Pesanan #' . $order->id); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.master.orders.index')); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Pesanan #<?php echo e($order->id); ?></h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Dibuat pada <?php echo e($order->created_at->format('d M Y H:i')); ?>

                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <!-- Dropdown Cetak Nota -->
            <div class="relative group">
                <button class="flex items-center bg-blue-500 hover:bg-blue-600 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200">
                    <i class="fas fa-print mr-2 text-sm"></i>
                    <span>Cetak Nota</span>
                    <i class="fas fa-chevron-down ml-2 text-xs"></i>
                </button>
                <div class="absolute right-0 mt-2 w-56 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                    <div class="py-2">
                        <a href="<?php echo e(route('admin.print.order.invoice', $order)); ?>" target="_blank"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-eye mr-3 text-blue-600 dark:text-blue-400"></i>
                            <div>
                                <div class="font-medium">Lihat & Print</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Preview sebelum cetak</div>
                            </div>
                        </a>
                        <a href="<?php echo e(route('admin.print.order.invoice.download', $order)); ?>"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-file-download mr-3 text-green-600 dark:text-green-400"></i>
                            <div>
                                <div class="font-medium">Download PDF</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Simpan file PDF</div>
                            </div>
                        </a>
                        <?php if($order->order_type === 'penawaran' && $order->inquiry): ?>
                        <a href="<?php echo e(route('admin.print.quotation.offer.preview', $order->inquiry)); ?>" target="_blank"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-file-alt mr-3 text-purple-600 dark:text-purple-400"></i>
                            <div>
                                <div class="font-medium">Dokumen Penawaran</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Preview penawaran</div>
                            </div>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Product Image -->
    <?php if($order->product && $order->product->product_image): ?>
        <div class="mb-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center gap-4">
                <div class="flex-shrink-0">
                    <img src="<?php echo e(asset('uploads/products/' . $order->product->product_image)); ?>"
                        alt="<?php echo e($order->product->product_title); ?>"
                        class="w-32 h-32 object-contain rounded-lg"
                        style="background: transparent;">
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-1"><?php echo e($order->product->product_title); ?></h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Produk Pesanan</p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Customer Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Customer</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Nama:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($order->customer_name); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Email:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100 break-all"><?php echo e($order->customer_email); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Telepon:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($order->phone_number); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Alamat:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($order->address); ?></span>
                </div>
            </div>
        </div>

        <!-- Order Details -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                    <i class="fas fa-box text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Detail Pesanan</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Produk:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e(Str::limit($order->product->product_title ?? 'N/A', 30)); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Quantity:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($order->quantity); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Total:</span>
                    <span class="text-xs font-semibold text-green-600 dark:text-green-400"><?php echo e($order->formatted_total_price); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Bayar:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e(ucfirst($order->payment_method ?? '-')); ?></span>
                </div>
                <?php if($order->payment_method === 'dp'): ?>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">DP:</span>
                    <div class="flex items-center space-x-1.5">
                        <span id="dp-percentage-display" class="text-xs text-gray-900 dark:text-gray-100 font-semibold"><?php echo e(number_format($order->dp_percentage ?? 30.00, 0)); ?>%</span>
                        <form id="dp-percentage-form" action="<?php echo e(route('admin.master.orders.updateDpPercentage', $order->id)); ?>" method="POST" class="inline-flex items-center space-x-1">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <input type="number" 
                                   id="dp-percentage-input"
                                   name="dp_percentage" 
                                   value="<?php echo e(number_format($order->dp_percentage ?? 30.00, 0)); ?>" 
                                   min="15" 
                                   max="50" 
                                   step="1"
                                   class="w-14 px-1.5 py-0.5 text-xs border border-gray-300 dark:border-gray-600 rounded focus:ring-2 focus:ring-orange-500 focus:outline-none bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                            <button type="submit" 
                                    id="dp-percentage-submit"
                                    class="px-1.5 py-0.5 text-xs bg-orange-500 hover:bg-orange-600 text-white rounded transition-colors"
                                    title="Update Persentase DP">
                                <i class="fas fa-save text-xs"></i>
                            </button>
                        </form>
                        <span class="text-[10px] text-gray-500 dark:text-gray-400">(15-50%)</span>
                    </div>
                </div>
                <?php endif; ?>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Jenis:</span>
                    <?php $otype = $order->order_type ?? 'beli_langsung'; ?>
                    <span class="inline-flex items-center px-2 py-0.5 rounded-md text-xs font-medium
                        <?php if($otype === 'penawaran'): ?> bg-purple-100 dark:bg-purple-900/40 text-purple-700 dark:text-purple-300
                        <?php else: ?> bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300 <?php endif; ?>">
                        <?php echo e($otype === 'penawaran' ? 'Penawaran' : 'Beli Langsung'); ?>

                    </span>
                </div>
            </div>
        </div>

        <!-- Status Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                    <i class="fas fa-cog text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Status</h3>
            </div>
            
            <!-- Payment Status -->
            <div class="mb-3">
                <label class="text-xs font-medium text-gray-600 dark:text-gray-400 block mb-1.5">Status Pembayaran</label>
                <form action="<?php echo e(route('admin.master.orders.updatePaymentStatus', $order->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <select name="payment_status" onchange="this.form.submit()"
                        class="w-full px-2.5 py-1.5 text-xs border border-gray-300 dark:border-gray-600 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                        <option value="menunggu" <?php echo e($order->status == 'menunggu' ? 'selected' : ''); ?>>Menunggu</option>
                        <option value="menunggu_verifikasi" <?php echo e($order->status == 'menunggu_verifikasi' ? 'selected' : ''); ?>>Menunggu Verifikasi</option>
                        <option value="diproses" <?php echo e($order->status == 'diproses' ? 'selected' : ''); ?>>Diproses</option>
                        <option value="selesai" <?php echo e($order->status == 'selesai' ? 'selected' : ''); ?>>Selesai</option>
                        <option value="gagal" <?php echo e($order->status == 'gagal' ? 'selected' : ''); ?>>Gagal</option>
                        <option value="dibatalkan" <?php echo e($order->status == 'dibatalkan' ? 'selected' : ''); ?>>Dibatalkan</option>
                    </select>
                </form>
            </div>

            <!-- Order Status -->
            <div class="mb-3">
                <label class="text-xs font-medium text-gray-600 dark:text-gray-400 block mb-1.5">Status Pesanan</label>
                <form action="<?php echo e(route('admin.master.orders.updateStatus', $order->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <select name="status" onchange="this.form.submit()"
                        class="w-full px-2.5 py-1.5 text-xs border border-gray-300 dark:border-gray-600 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                        <option value="menunggu" <?php echo e($order->order_status == 'menunggu' ? 'selected' : ''); ?>>Menunggu</option>
                        <option value="diterima" <?php echo e($order->order_status == 'diterima' ? 'selected' : ''); ?>>Diterima</option>
                        <option value="ditolak" <?php echo e($order->order_status == 'ditolak' ? 'selected' : ''); ?>>Ditolak</option>
                    </select>
                </form>
            </div>

            <!-- Production Status -->
            <div>
                <label class="text-xs font-medium text-gray-600 dark:text-gray-400 block mb-1.5">Status Produksi</label>
                <?php
                    $prodStatus = $order->production_status ?? 'menunggu';
                    $prodStatusLabels = [
                        'menunggu' => 'Menunggu',
                        'dalam_proses' => 'Dalam Proses',
                        'selesai' => 'Selesai',
                        'dibatalkan' => 'Dibatalkan'
                    ];
                    $prodStatusColors = [
                        'menunggu' => 'bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300',
                        'dalam_proses' => 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300',
                        'selesai' => 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300',
                        'dibatalkan' => 'bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300'
                    ];
                ?>
                <div class="w-full px-2.5 py-1.5 text-xs border border-gray-300 dark:border-gray-600 rounded-md bg-gray-50 dark:bg-gray-700/50 text-gray-900 dark:text-white">
                    <span class="inline-flex items-center px-2 py-0.5 rounded-md text-xs font-medium <?php echo e($prodStatusColors[$prodStatus] ?? $prodStatusColors['menunggu']); ?>">
                        <?php echo e($prodStatusLabels[$prodStatus] ?? 'Menunggu'); ?>

                    </span>
                </div>
                <p class="text-[10px] text-gray-500 dark:text-gray-400 mt-1">
                    <i class="fas fa-info-circle mr-1"></i>Status produksi diatur otomatis melalui workflow
                </p>
            </div>
        </div>
    </div>

    <!-- Payment Proof -->
    <div class="mt-4 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-3">
            <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                <i class="fas fa-receipt text-purple-600 dark:text-purple-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Bukti Pembayaran</h3>
        </div>

        <?php
            // Cek apakah file benar-benar ada di storage
            $proofExists = false;
            $fileUrl = null;
            $isImage = false;
            
            if ($order->proof_file) {
                // Cek apakah file ada di storage
                $proofExists = \Storage::disk('uploads')->exists($order->proof_file);
                
                if ($proofExists) {
                    // Untuk admin, gunakan route admin khusus
                    try {
                        $fileUrl = route('admin.master.orders.proof', $order->id);
                    } catch (\Exception $e) {
                        // Fallback 1: coba route user biasa
                        try {
                            $fileUrl = route('orders.proof', $order->id);
                        } catch (\Exception $e2) {
                            // Fallback 2: gunakan asset() langsung
                            $fileUrl = asset('uploads/' . $order->proof_file);
                        }
                    }
                    
                    $extension = pathinfo($order->proof_file, PATHINFO_EXTENSION);
                    $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif', 'webp']);
                }
            }
        ?>
        
        <?php if($order->proof_file && $proofExists && $fileUrl): ?>
            <div class="bg-gray-50 dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-300 mb-0.5">
                            <span class="font-medium">File:</span> <?php echo e(Str::limit(basename($order->proof_file), 30)); ?>

                        </p>
                        <p class="text-[10px] text-gray-500 dark:text-gray-400">
                            Uploaded: <?php echo e($order->updated_at->format('d M Y H:i')); ?>

                        </p>
                    </div>
                    <div class="flex items-center space-x-1.5">
                        <a href="<?php echo e($fileUrl); ?>" target="_blank"
                            class="inline-flex items-center px-2.5 py-1 bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300 rounded-md text-xs font-medium hover:bg-blue-200 dark:hover:bg-blue-900/60 transition-colors duration-200">
                            <i class="fas fa-eye mr-1 text-xs"></i> Lihat
                        </a>
                        <a href="<?php echo e($fileUrl); ?>" download
                            class="inline-flex items-center px-2.5 py-1 bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300 rounded-md text-xs font-medium hover:bg-green-200 dark:hover:bg-green-900/60 transition-colors duration-200">
                            <i class="fas fa-download mr-1 text-xs"></i> Download
                        </a>
                    </div>
                </div>
                
                <?php if($isImage): ?>
                    <div class="mt-3">
                        <img src="<?php echo e($fileUrl); ?>" 
                             alt="Bukti Pembayaran" 
                             class="w-full max-w-md mx-auto rounded-lg border border-gray-300 dark:border-gray-600 cursor-pointer hover:opacity-90 transition-opacity duration-200"
                             onclick="window.open('<?php echo e($fileUrl); ?>', '_blank')"
                             onerror="this.onerror=null; this.src='<?php echo e(asset('uploads/' . $order->proof_file)); ?>';"
                             style="max-height: 200px; object-fit: contain; background: transparent;">
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif($order->proof_file && !$proofExists): ?>
            <div class="text-center py-4">
                <div class="w-12 h-12 mx-auto mb-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-full flex items-center justify-center">
                    <i class="fas fa-exclamation-triangle text-yellow-600 dark:text-yellow-400"></i>
                </div>
                <p class="text-xs text-yellow-600 dark:text-yellow-400">File bukti pembayaran tidak ditemukan di storage</p>
                <p class="text-[10px] text-gray-500 dark:text-gray-400 mt-1">Path: <?php echo e($order->proof_file); ?></p>
            </div>
        <?php else: ?>
            <div class="text-center py-4">
                <div class="w-12 h-12 mx-auto mb-2 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center">
                    <i class="fas fa-file-upload text-gray-400 dark:text-gray-500"></i>
                </div>
                <p class="text-xs text-gray-500 dark:text-gray-400">Belum ada bukti pembayaran yang diunggah</p>
            </div>
        <?php endif; ?>
    </div>

    <?php if($order->inquiry): ?>
    <div class="mt-4 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700 bg-blue-50 dark:bg-blue-900/20 flex items-center justify-between">
            <h3 class="text-base font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-file-signature mr-2 text-blue-600 dark:text-blue-400 text-sm"></i>
                Spesifikasi Tambahan (Penawaran)
            </h3>
            <?php
                $raw = $order->inquiry->message ?? '';
                $lines = preg_split("/(\r\n|\n|\r)/", $raw);
                $type = null; $addons = []; $hasAddonsLine = false;
                if (!empty($lines)) {
                    $first = $lines[0] ?? '';
                    $second = $lines[1] ?? '';
                    if (substr($first, 0, 14) === '[REQUEST_TYPE]') { $type = trim(substr($first, 14)); }
                    if (substr($second, 0, 8) === '[ADDONS]') {
                        $hasAddonsLine = true;
                        $matches = [];
                        if (preg_match('/^\[ADDONS\]\s*(\[[\s\S]*\])$/', $second, $matches)) {
                            $decoded = json_decode($matches[1], true);
                            if (is_array($decoded)) { $addons = $decoded; }
                        }
                    }
                }
                $startIdx = 0; if ($type) { $startIdx++; } if ($hasAddonsLine) { $startIdx++; }
                if (!empty($lines) && isset($lines[$startIdx]) && trim($lines[$startIdx]) === '') { $startIdx++; }
                $plain = implode("\n", array_slice($lines, $startIdx));
                $badgeText = $type === 'custom_addon' ? 'Custom Add-on' : ($type === 'custom_new' ? 'Custom Baru' : ($type ? 'Katalog' : null));
                $badgeCls = $type === 'custom_addon' ? 'bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300' : ($type === 'custom_new' ? 'bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300' : 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300');
            ?>
            <?php if($badgeText): ?>
            <span class="inline-flex items-center px-2 py-0.5 rounded-md text-xs font-medium <?php echo e($badgeCls); ?>"><?php echo e($badgeText); ?></span>
            <?php endif; ?>
        </div>
        <div class="p-4 space-y-4">
            <?php
                $materials = is_array($order->inquiry->materials_breakdown ?? null) ? $order->inquiry->materials_breakdown : [];
                $spareparts = is_array($order->inquiry->spareparts_breakdown ?? null) ? $order->inquiry->spareparts_breakdown : [];
            ?>
            <?php if(!empty($addons)): ?>
            <div>
                <div class="flex items-center mb-2">
                    <div class="w-6 h-6 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg flex items-center justify-center mr-2">
                        <i class="fas fa-tools text-yellow-700 dark:text-yellow-300 text-xs"></i>
                    </div>
                    <div class="text-xs font-semibold text-gray-900 dark:text-white">Pilihan Tambahan</div>
                </div>
                <?php
                    $preview = collect($addons)->map(function($a){
                        $name = is_array($a) ? ($a['name'] ?? ($a['label'] ?? '')) : '';
                        $value = is_array($a) ? ($a['value'] ?? ($a['selected'] ?? '')) : '';
                        return trim(($name ?: '-') . ': ' . ($value ?: '-'));
                    })->implode("\n");
                ?>
                <pre class="text-xs whitespace-pre-wrap bg-gray-50 dark:bg-gray-700/50 p-2.5 rounded-lg border border-gray-200 dark:border-gray-600"><?php echo e($preview); ?></pre>
            </div>
            <?php endif; ?>

            <?php if(!empty($materials)): ?>
            <div>
                <div class="flex items-center mb-2">
                    <div class="w-6 h-6 bg-blue-100 dark:bg-blue-900/40 rounded-lg flex items-center justify-center mr-2">
                        <i class="fas fa-box-open text-blue-700 dark:text-blue-300 text-xs"></i>
                    </div>
                    <div class="text-xs font-semibold text-gray-900 dark:text-white">Bahan Tambahan</div>
                </div>
                <div class="space-y-1.5">
                    <?php $__currentLoopData = $materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $n = is_array($m) ? ($m['name'] ?? ($m['material_name'] ?? '')) : '';
                            $q = is_array($m) ? ($m['quantity'] ?? ($m['qty'] ?? '')) : '';
                            $u = is_array($m) ? ($m['unit'] ?? '') : '';
                            $c = is_array($m) ? ($m['unit_cost'] ?? ($m['cost'] ?? '')) : '';
                        ?>
                        <div class="flex items-center justify-between p-2 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
                            <div class="text-xs text-gray-900 dark:text-white">
                                <span class="font-medium"><?php echo e($n ?: '-'); ?></span>
                                <span class="text-gray-500 dark:text-gray-400"> — <?php echo e($q ?: '-'); ?> <?php echo e($u); ?></span>
                            </div>
                            <?php if($c !== ''): ?>
                            <div class="text-xs font-semibold text-gray-900 dark:text-white">Rp <?php echo e(is_numeric($c) ? number_format($c, 0, ',', '.') : $c); ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if(!empty($spareparts)): ?>
            <div>
                <div class="flex items-center mb-2">
                    <div class="w-6 h-6 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg flex items-center justify-center mr-2">
                        <i class="fas fa-cogs text-emerald-700 dark:text-emerald-300 text-xs"></i>
                    </div>
                    <div class="text-xs font-semibold text-gray-900 dark:text-white">Sparepart Tambahan</div>
                </div>
                <div class="space-y-1.5">
                    <?php $__currentLoopData = $spareparts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $n = is_array($s) ? ($s['name'] ?? ($s['part_name'] ?? '')) : '';
                            $q = is_array($s) ? ($s['quantity'] ?? ($s['qty'] ?? '')) : '';
                            $u = is_array($s) ? ($s['unit'] ?? '') : '';
                            $c = is_array($s) ? ($s['unit_cost'] ?? ($s['cost'] ?? '')) : '';
                        ?>
                        <div class="flex items-center justify-between p-2 bg-emerald-50 dark:bg-emerald-900/20 rounded-lg border border-emerald-200 dark:border-emerald-800">
                            <div class="text-xs text-gray-900 dark:text-white">
                                <span class="font-medium"><?php echo e($n ?: '-'); ?></span>
                                <span class="text-gray-500 dark:text-gray-400"> — <?php echo e($q ?: '-'); ?> <?php echo e($u); ?></span>
                            </div>
                            <?php if($c !== ''): ?>
                            <div class="text-xs font-semibold text-gray-900 dark:text-white">Rp <?php echo e(is_numeric($c) ? number_format($c, 0, ',', '.') : $c); ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if(trim($plain) !== ''): ?>
            <div>
                <div class="flex items-center mb-2">
                    <div class="w-6 h-6 bg-gray-100 dark:bg-gray-700 rounded-lg flex items-center justify-center mr-2">
                        <i class="fas fa-comment-dots text-gray-700 dark:text-gray-300 text-xs"></i>
                    </div>
                    <div class="text-xs font-semibold text-gray-900 dark:text-white">Catatan Customer</div>
                </div>
                <p class="text-xs text-gray-800 dark:text-gray-200 whitespace-pre-wrap"><?php echo e($plain); ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    body {
        font-family: Arial, sans-serif;
        font-size: 12px;
        line-height: 1.4;
        color: #000;
        background: #fff;
    }
    
    .print-header {
        text-align: center;
        border-bottom: 2px solid #000;
        padding-bottom: 10px;
        margin-bottom: 20px;
    }
    
    .print-title {
        font-size: 18px;
        font-weight: bold;
        margin-bottom: 5px;
    }
    
    .print-subtitle {
        font-size: 14px;
        color: #666;
    }
    
    .print-section {
        margin-bottom: 15px;
        page-break-inside: avoid;
    }
    
    .print-section-title {
        font-weight: bold;
        font-size: 14px;
        margin-bottom: 8px;
        border-bottom: 1px solid #ccc;
        padding-bottom: 3px;
    }
    
    .print-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
    }
    
    .print-label {
        font-weight: bold;
        width: 40%;
    }
    
    .print-value {
        width: 60%;
    }
    
    .print-total {
        font-weight: bold;
        font-size: 16px;
        text-align: right;
        border-top: 2px solid #000;
        padding-top: 10px;
        margin-top: 20px;
    }
    
    .print-footer {
        margin-top: 30px;
        text-align: center;
        font-size: 10px;
        color: #666;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dpForm = document.getElementById('dp-percentage-form');
    const dpInput = document.getElementById('dp-percentage-input');
    const dpDisplay = document.getElementById('dp-percentage-display');
    const dpSubmit = document.getElementById('dp-percentage-submit');
    
    if (dpForm) {
        dpForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const newPercentage = dpInput.value;
            const oldPercentage = dpDisplay.textContent.replace('%', '');
            
            // Validasi
            if (newPercentage < 15 || newPercentage > 50) {
                Swal.fire({
                    icon: 'error',
                    title: 'Nilai Tidak Valid',
                    text: 'Persentase DP harus antara 15% - 50%',
                    position: 'center',
                    confirmButtonColor: '#ef4444',
                    allowOutsideClick: false
                });
                return;
            }
            
            // Konfirmasi dengan SweetAlert
            Swal.fire({
                title: 'Ubah Persentase DP?',
                html: `Ubah dari <strong>${oldPercentage}%</strong> menjadi <strong>${newPercentage}%</strong>?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#f97316',
                cancelButtonColor: '#6b7280',
                confirmButtonText: '<i class="fas fa-check mr-2"></i>Ya, Ubah',
                cancelButtonText: '<i class="fas fa-times mr-2"></i>Batal',
                position: 'center',
                allowOutsideClick: false,
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Disable button dan show loading
                    dpSubmit.disabled = true;
                    const originalHtml = dpSubmit.innerHTML;
                    dpSubmit.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                    
                    // Buat FormData
                    const formData = new FormData(dpForm);
                    
                    // AJAX request
                    fetch(dpForm.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => {
                        // Cek jika response adalah JSON
                        const contentType = response.headers.get('content-type');
                        if (contentType && contentType.includes('application/json')) {
                            return response.json();
                        } else {
                            // Jika bukan JSON, throw error
                            throw new Error('Response bukan JSON');
                        }
                    })
                    .then(data => {
                        // Reset button terlebih dahulu
                        dpSubmit.disabled = false;
                        dpSubmit.innerHTML = originalHtml;
                        
                        if (data.success) {
                            // Update display
                            dpDisplay.textContent = newPercentage + '%';
                            
                            // Notifikasi sukses
                            Swal.fire({
                                icon: 'success',
                                title: 'Berhasil!',
                                text: data.message || 'Persentase DP berhasil diubah menjadi ' + newPercentage + '%',
                                position: 'center',
                                confirmButtonColor: '#10b981',
                                timer: 2000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                showConfirmButton: true
                            });
                            
                            // Jika ada receivable dan status diproses, reload untuk update tampilan
                            <?php if($order->receivable && $order->status === 'diproses'): ?>
                                setTimeout(() => {
                                    window.location.reload();
                                }, 2000);
                            <?php endif; ?>
                        } else {
                            // Notifikasi error
                            Swal.fire({
                                icon: 'error',
                                title: 'Gagal!',
                                text: data.message || 'Gagal mengubah persentase DP',
                                position: 'center',
                                confirmButtonColor: '#ef4444',
                                allowOutsideClick: false
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        
                        // Reset button
                        dpSubmit.disabled = false;
                        dpSubmit.innerHTML = originalHtml;
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Terjadi Kesalahan!',
                            text: 'Terjadi kesalahan saat mengubah persentase DP. Silakan coba lagi.',
                            position: 'center',
                            confirmButtonColor: '#ef4444',
                            allowOutsideClick: false
                        });
                    });
                }
            });
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/master/orders/show.blade.php ENDPATH**/ ?>