
<?php
    $steps = [
        [
            'label' => 'Pesanan Diterima', 
            'done' => $production->order->order_status === 'diterima', 
            'icon' => 'clipboard-check',
            'date' => $production->order->created_at,
        ],
        [
            'label' => 'Ditugaskan', 
            'done' => (bool)$production->teknisi_id, 
            'icon' => 'user-check',
            'date' => $production->assigned_at,
        ],
        [
            'label' => 'Planning Disetujui', 
            'done' => $production->planning_status === 'approved', 
            'pending' => $production->planning_status === 'pending_approval',
            'rejected' => $production->planning_status === 'rejected',
            'icon' => 'file-signature',
            'date' => $production->approved_at,
        ],
        [
            'label' => 'Produksi', 
            'done' => in_array($production->status, ['dalam_proses', 'selesai']), 
            'icon' => 'industry',
            'date' => $production->actual_start_date,
        ],
        [
            'label' => 'Selesai', 
            'done' => $production->status === 'selesai', 
            'pending' => $production->completion_status === 'pending_approval',
            'icon' => 'check-circle',
            'date' => $production->end_date,
        ],
    ];
    
    // Hitung index step terakhir yang done
    $lastDoneIndex = -1;
    foreach($steps as $index => $step) {
        if ($step['done']) {
            $lastDoneIndex = $index;
        }
    }
?>

<div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden mb-6">
    
    <div class="px-5 py-4 bg-blue-50 dark:bg-blue-900/20 border-b border-gray-200 dark:border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-tasks text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">Progress Produksi</h3>
                    <p class="text-xs text-gray-600 dark:text-gray-400">Lacak kemajuan pembuatan produk</p>
                </div>
            </div>
            <?php if(isset($showEstimate) && $showEstimate && $production->estimated_completion_date && $production->status === 'dalam_proses'): ?>
            <div class="bg-white dark:bg-gray-700 rounded-lg px-4 py-2.5 border border-gray-200 dark:border-gray-600">
                <p class="text-xs text-gray-600 dark:text-gray-400 font-medium">Estimasi Selesai</p>
                <p class="text-sm font-bold text-blue-600 dark:text-blue-400"><?php echo e($production->estimated_completion_date->format('d M Y')); ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    
    <div class="p-5">
        
        <div class="hidden md:block">
            <div class="relative">
                
                <div class="absolute top-5 left-0 right-0 h-0.5 bg-gray-200 dark:bg-gray-700" style="margin-left: 5%; margin-right: 5%;"></div>
                
                
                <?php if($lastDoneIndex >= 0): ?>
                <?php
                    $stepWidth = 90 / (count($steps) - 1);
                    $progressWidth = $lastDoneIndex * $stepWidth;
                ?>
                <div class="absolute top-5 h-0.5 bg-green-500 dark:bg-green-400 transition-all duration-500" 
                     style="left: 5%; width: <?php echo e($progressWidth); ?>%;"></div>
                <?php endif; ?>
                
                <div class="relative flex justify-between">
                    <?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex flex-col items-center" style="width: <?php echo e(100 / count($steps)); ?>%">
                        
                        <div class="w-10 h-10 rounded-full flex items-center justify-center z-10 border-2 transition-all duration-300
                            <?php if($step['done']): ?>
                                bg-green-500 dark:bg-green-600 border-green-200 dark:border-green-800 text-white
                            <?php elseif($step['pending'] ?? false): ?>
                                bg-yellow-500 dark:bg-yellow-600 border-yellow-200 dark:border-yellow-800 text-white
                            <?php elseif($step['rejected'] ?? false): ?>
                                bg-red-500 dark:bg-red-600 border-red-200 dark:border-red-800 text-white
                            <?php else: ?>
                                bg-white dark:bg-gray-700 border-gray-300 dark:border-gray-600 text-gray-400 dark:text-gray-500
                            <?php endif; ?>">
                            <?php
                                // Icon berbeda untuk setiap step
                                $iconMap = [
                                    'Pesanan Diterima' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>'
                                    ],
                                    'Ditugaskan' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>'
                                    ],
                                    'Planning Disetujui' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>'
                                    ],
                                    'Produksi' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>'
                                    ],
                                    'Selesai' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>'
                                    ]
                                ];
                                
                                $iconKey = $step['label'];
                                $iconType = 'default';
                                if ($step['done']) {
                                    $iconType = 'done';
                                } elseif ($step['pending'] ?? false) {
                                    $iconType = 'pending';
                                } elseif ($step['rejected'] ?? false) {
                                    $iconType = 'rejected';
                                }
                                
                                // Icon X untuk rejected
                                if ($iconType === 'rejected') {
                                    $iconPath = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>';
                                } else {
                                    $iconPath = $iconMap[$iconKey][$iconType] ?? $iconMap[$iconKey]['default'] ?? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>';
                                }
                            ?>
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <?php echo $iconPath; ?>

                            </svg>
                        </div>
                        
                        
                        <p class="text-xs text-center mt-3 font-medium leading-tight max-w-[90px]
                            <?php if($step['done']): ?>
                                text-green-600 dark:text-green-400
                            <?php elseif($step['pending'] ?? false): ?>
                                text-yellow-600 dark:text-yellow-400
                            <?php elseif($step['rejected'] ?? false): ?>
                                text-red-600 dark:text-red-400
                            <?php else: ?>
                                text-gray-500 dark:text-gray-400
                            <?php endif; ?>">
                            <?php echo e($step['label']); ?>

                        </p>
                        
                        
                        <?php if($step['done'] && $step['date']): ?>
                        <p class="text-[10px] text-gray-500 dark:text-gray-400 mt-1">
                            <?php echo e($step['date']->format('d M Y')); ?>

                        </p>
                        <?php elseif($step['pending'] ?? false): ?>
                        <p class="text-[10px] text-yellow-600 dark:text-yellow-400 mt-1 font-medium">
                            Menunggu
                        </p>
                        <?php elseif($step['rejected'] ?? false): ?>
                        <p class="text-[10px] text-red-600 dark:text-red-400 mt-1 font-medium">
                            Ditolak
                        </p>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        
        <div class="md:hidden">
            <div class="relative">
                
                <div class="absolute left-4 top-0 bottom-0 w-0.5 bg-gray-200 dark:bg-gray-700"></div>

                <div class="space-y-4">
                    <?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="relative flex items-start">
                        
                        <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center z-10
                            <?php if($step['done']): ?>
                                bg-green-500 dark:bg-green-600
                            <?php elseif($step['pending'] ?? false): ?>
                                bg-yellow-500 dark:bg-yellow-600
                            <?php elseif($step['rejected'] ?? false): ?>
                                bg-red-500 dark:bg-red-600
                            <?php else: ?>
                                bg-gray-300 dark:bg-gray-600
                            <?php endif; ?>">
                            <?php
                                // Icon berbeda untuk setiap step (sama dengan desktop)
                                $iconMap = [
                                    'Pesanan Diterima' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>'
                                    ],
                                    'Ditugaskan' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>'
                                    ],
                                    'Planning Disetujui' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>'
                                    ],
                                    'Produksi' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>'
                                    ],
                                    'Selesai' => [
                                        'done' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                        'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>',
                                        'default' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>'
                                    ]
                                ];
                                
                                $iconKey = $step['label'];
                                $iconType = 'default';
                                if ($step['done']) {
                                    $iconType = 'done';
                                } elseif ($step['pending'] ?? false) {
                                    $iconType = 'pending';
                                } elseif ($step['rejected'] ?? false) {
                                    $iconType = 'rejected';
                                }
                                
                                // Icon X untuk rejected
                                if ($iconType === 'rejected') {
                                    $iconPath = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>';
                                } else {
                                    $iconPath = $iconMap[$iconKey][$iconType] ?? $iconMap[$iconKey]['default'] ?? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>';
                                }
                            ?>
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <?php echo $iconPath; ?>

                            </svg>
                        </div>
                        
                        
                        <div class="ml-4 flex-1 bg-gray-50 dark:bg-gray-700/50 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                            <div class="flex items-center justify-between mb-1">
                                <h4 class="text-sm font-semibold 
                                    <?php if($step['done']): ?>
                                        text-gray-900 dark:text-white
                                    <?php else: ?>
                                        text-gray-500 dark:text-gray-400
                                    <?php endif; ?>">
                                    <?php echo e($step['label']); ?>

                                </h4>
                                <?php if($step['done']): ?>
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                        Selesai
                                    </span>
                                <?php elseif($step['pending'] ?? false): ?>
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                                        Menunggu
                                    </span>
                                <?php elseif($step['rejected'] ?? false): ?>
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300">
                                        Ditolak
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-400">
                                        Belum
                                    </span>
                                <?php endif; ?>
                            </div>
                            <?php if($step['done'] && $step['date']): ?>
                                <p class="text-xs text-gray-600 dark:text-gray-400"><?php echo e($step['date']->format('d M Y')); ?></p>
                            <?php elseif($step['pending'] ?? false): ?>
                                <p class="text-xs text-yellow-700 dark:text-yellow-300 font-medium">Menunggu persetujuan</p>
                            <?php elseif($step['rejected'] ?? false): ?>
                                <p class="text-xs text-red-700 dark:text-red-300 font-medium">Planning ditolak</p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/shared/partials/production-timeline.blade.php ENDPATH**/ ?>